<?PHP  if ( ! defined('BASEPATH')) exit('No direct script access allowed'); 
/**
* @package direct-project-innovation-initiative
* @subpackage libraries
*/

require_once 'Object.php';
require_once APPPATH.'libraries/ccd.php';
require_once APPPATH.'models/message.php';
require_once APPPATH.'models/das_log_entry.php';

/**
* @package direct-project-innovation-initiative
* @subpackage libraries
* @todo - separate patient document methods into a child class
*/
class Attachment extends Object{		
	protected $name; //the actual name + extension: e.g. 'myfile.txt', without the full path
	protected $_directory; //the full path EXCLUDING the filename: i.e. /www/htdocs/, not /www/htdocs/myfile.txt.  Will always have a trailing slash.
	protected $_binary_string;
	protected $_message_id;
	protected $_filetype;
	protected $_extension;
	protected $_cid;
	protected $_schema;
	protected $_description;
	protected $_url;
	protected $_das_save_date;
	protected $_parser;
	protected $_html_friendly_name; //a version of the file name that will be appropriate for form names and css classes
	protected $_purpose;
	protected $_ssn;

	protected $_property_validation_rules= array( 'binary_string' => 'string',
												  'extension' => 'string_with_no_whitespace',
												  'filetype' => 'string_with_no_whitespace',
												  'name' => 'string_like_a_file_path',
												  'cid' => 'nonempty_string',
												  'url' => 'string_like_a_url',
												  'purpose' => 'nonempty_string',
												 );
////////////////////
// GETTERS
////////////////////
		
#TODO -> do we need to update this if they supply content?		
	function binary_string(){
		if(isset($this->_binary_string)) return $this->_binary_string;
		if(!empty($this->path())){
			if(!file_exists($this->path())) $this->error->warning('Unable to find file: '.$this->path());
			$this->_binary_string = file_get_contents($this->path());
			return $this->_binary_string;
		}
		return $this->error->warning('No binary string has been set');
	}
	
	function bytes(){
		if(!empty($this->path()) || isset($this->binary_string)) return string_length_in_bytes($this->binary_string);
		return 0; //file doesn't have a path or a binary string, so its current size is 0
	}
	
	function das_save_date($format = null){
		if(!isset($this->_das_save_date) && $this->schema == 'C32'){
			get_instance()->db->select('id, message_id, saved_date')->order_by('saved_date', 'desc');
			$saved_info = DAS_log_entry::find_one_for_attachment($this);
			if(DAS_log_entry::is_an_entity($saved_info)){ $this->_das_save_date = $saved_info->saved_date; }
		}
		if(!is_null($format) && isset($this->_das_save_date)){ return date($format, $this->_das_save_date);}
		return $this->_das_save_date;
	}
	
	function description(){
		if(!isset($this->_description) && isset($this->binary_string)){
			if(Ccd::string_matches_schema($this->binary_string)){
				$document = new Ccd($this->binary_string);
				return $document->description();
			} 
		}
		return $this->_description;
	}		
	
	function extension(){
		if(!isset($this->_extension)) return strtolower(pathinfo($this->name, PATHINFO_EXTENSION));
		return $this->_extension; //we may have grabbed an extension from a mime for an attached file, so we may have better info than just the filename
	}
	
	function hash(){
		if(!$this->property_is_empty('binary_string'));
		return sha1($this->binary_string);
	}
	
	function html_friendly_name(){
		return make_string_css_friendly($this->name);
	}
	
	function filetype(){
		if(!isset($this->filetype)) return $this->extension;
		$this->_filetype;
	}
	
	function filename(){
		return $this->name;
	}
	
	function metadata(){
		$properties = array_keys(get_object_vars($this));
		foreach($properties as &$property)
			$property = strip_from_beginning('_', $property);
				
		$properties = array_merge(array_diff($properties, array('is', 'validator', 'error', 'property_validation_rules', 'binary_string', 'parser')), array('bytes', 'path', 'url'));		
	
		$metadata = array();
		$only_if_not_empty = array('message_id', 'cid', 'das_save_date', 'schema', 'description', 'url');
		foreach($properties as $property){
			$property = strip_from_beginning('_', $property);
			if(!in_array($property, $only_if_not_empty) || !$this->property_is_empty($property)){
				$metadata[$property] = $this->$property;
			}
		}
		
		return $metadata;
	}
	
	function parser(){
		if(!isset($this->_parser) && $this->schema == 'C32' ){
			$this->_parser = new ccd($this->binary_string);
		}
		return $this->_parser;
	}
	
	//the full path of the directory + filename; will only be supplied if both directory path and name has been populated
	function path(){
		if(isset($this->directory) && isset($this->name)){
			return $this->directory.$this->name;
		}
	}
	
	function schema(){
		if(!isset($this->_schema) && isset($this->binary_string)){
			if(ccd::string_matches_schema($this->binary_string))
				$this->_schema = 'C32';
		}
		return $this->_schema;
	}
	
	//deprecated alias for binary_string
	function string(){
		return $this->binary_string;	
	}
	
	function url(){
		if(isset($this->message_id)){
			if(in_array($this->extension, array('jpeg', 'jpg', 'gif', 'png')))
				return site_url('inbox/imgdisp/' . $this->message_id. '/' . rawurlencode($this->name));
			else	
				return site_url('inbox/get_attachment/' . $this->message_id. '/' . rawurlencode($this->name));
		}elseif(!empty($this->path()) &&  string_begins_with(get_instance()->user->attachment_cache(), $this->path())){
			return site_url('inbox/preview_attachment/'.rawurlencode($this->name));
		}
	}


//////////////////////
// SETTERS
//////////////////////

	//ensure that the path value always has a trailing slash && that the directory exists
	function set_directory($value){
		if(!$this->is->directory_path($value)) return $this->error->property_value_should_be_an_existing_directory_path('directory', $this, $value);
		$this->_directory = strip_from_end('/', $value).'/'; //make sure we always have a trailing slash, but only one
	}
	
	
	function set_message_id($value){
		if(!Message::formatted_like_an_id($value)) return $this->error->property_value_should_be_a_message_id('message_id', $this, $value);
		$this->_message_id = $value; //we could check to see if the message really exists, but that would be expensive (API call) - we'll trust the developers in this case
	}
	

	function set_ssn($value){
		if(is_numeric($value) && strlen($value) == 9){
			$value = substr($value, 0, 3).'-'.substr($value, 3, 2).'-'.substr($value, 5, 4);
		}
		
		if(!$this->is->string_like_a_social_security_number($value)) return $this->error->property_value_should_be_a_ssn('ssn', $this, $value);	
		$this->_ssn = $value;
	}

/////////////////////////////////////////////////////////////////
// PATIENT DOCUMENT FUNCTIONS
// These should probably be moved into a child class eventually
/////////////////////////////////////////////////////////////////

	function save_disclosure(){
		if(!$this->schema == 'C32') return $this->error->warning('Disclosures may only be saved for C32s, but '.$this->name.' has a schema of '.$this->error->describe($this->schema));
		if($this->property_is_empty('message_id')) return $this->error->warning('Cannot save a disclosure for '.$this->name.' without a message id');

		
		
		$CI = get_instance();
		$values_to_save = array('mailbox' => $CI->mailbox->name,
								'id' => $this->message_id,
								'ssn' => str_replace('-', '', $this->ssn),
								'purpose' => $this->purpose,
								'hash' => $this->hash);
							
		$CI->api->clear();
		return $CI->api->call('direct/disclosure/log', $values_to_save,'POST');
	}
	

	
/////////////////////
// STATIC FUNCTIONS
/////////////////////
	
}
?>